
 
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.security.MessageDigest;  
import java.security.NoSuchAlgorithmException;  


class IMSdk {
	
	
	private String appId = "1476263646" ;
	private String appSecret = "A792D4A284DAB50" ;
	private String dataType = "json" ;
	private String restSite = "http://127.0.0.1:8050" ;

	private String ssid = "" ;
	private String uid = "" ;
	private String uname = "" ;
	

    public IMSdk(String ssid,String uid,String uname) { 
        this.ssid = ssid ;
		this.uid = uid ;
		this.uname = uname ;
    }


	public String getTokenInfo(String token){
		String param = "token=" + token ;
		String res = this.sendRest("oauth", "get_token_info",param) ;
		return res ;
	}


	public String sendRest(String module,String method,String param){
		
		String url = this.restSite + "/api/" + module + "/" + method + ".html";
		
		param += "&ssid=" + this.ssid;
		param += "&uid=" + this.uid;
		param += "&uname=" + this.uname;
		param += "&app_id=" + this.appId;
		param += "&data_type=" + this.dataType;
		param += "&authen=" + this.getAuthen();
		

		String res = sendPost(url,param);

		try{
			//res = new String(res.getBytes(), "utf-8");
		}catch(Exception e){
		}

		return res ;
	}
	
	
	

    public static String sendPost(String url, String param) {
        PrintWriter out = null;
        BufferedReader in = null;
        String result = "";
        try {
            URL realUrl = new URL(url);
            
            URLConnection conn = realUrl.openConnection();
            
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("user-agent","Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
			
            conn.setDoOutput(true);
            conn.setDoInput(true);
            
            out = new PrintWriter(conn.getOutputStream());
           
            out.print(param);
            
            out.flush();
           
            in = new BufferedReader(new InputStreamReader(conn.getInputStream(),"utf-8"));
            String line;
            while ((line = in.readLine()) != null) {
                result += line;
            }
        } catch (Exception e) {
            System.out.println("Send Post Error:"+e);
            e.printStackTrace();
        }
        
        finally{
            try{
                if(out!=null){
                    out.close();
                }
                if(in!=null){
                    in.close();
                }
            }
            catch(IOException ex){
                ex.printStackTrace();
            }
        }
		
		//result = unescapeUnicode(result);
        return result;
    } 
	


	private String getAuthen(){
		String text = this.appId + this.appSecret + this.ssid + this.uid ;
		return SHA(text, "SHA-256");  
	}
	

	  private String SHA(final String strText, final String strType)  
	  {  
		
		String strResult = null;  
	  
		
		if (strText != null && strText.length() > 0)  
		{  
		  try  
		  {  

			MessageDigest messageDigest = MessageDigest.getInstance(strType);  

			messageDigest.update(strText.getBytes());  
  
			byte byteBuffer[] = messageDigest.digest();  
	  
 
			StringBuffer strHexString = new StringBuffer();  

			for (int i = 0; i < byteBuffer.length; i++)  
			{  
			  String hex = Integer.toHexString(0xff & byteBuffer[i]);  
			  if (hex.length() == 1)  
			  {  
				strHexString.append('0');  
			  }  
			  strHexString.append(hex);  
			}  

			strResult = strHexString.toString();  
		  }  
		  catch (NoSuchAlgorithmException e)  
		  {  
			e.printStackTrace();  
		  }  
		}  
	  
		return strResult;  
	  }  
}

