<?php 
/*
 * 声明
 * 所有的结果返回格式是 status data err_code err_msg
 * status 0 错误  1 成功
 * data 返回结果数据
 * err_code 错误码
 * err_msg 错误信息
 * */

class IMSdk 
{ 
	//开发者需要这里----------------
	private $app_id = '1476263646' ;
	private $app_secret = 'A792D4A284DAB50' ;
	private $data_type = 'json' ;
	private $rest_site = 'http://101.69.228.146:8000' ;

	
	//当前登录的SSID ,USERID,USERNAME
	private $ssid = '';
	private $uid = '';
	private $uname = '';

	/**
	 * 初始化
	 */
	public function __construct($ssid,$uid,$uname){
		$this->ssid = $ssid ;
		$this->uid = $uid ;
		$this->uname = $uname ;
	}

	/**
	 * 验证令牌的详细信息
	 */
	public function getTokenInfo($token){
		$param = array('token'=>$token);
		$res = $this->sendRest('oauth', 'get_token_info',$param) ;
		return $res ;
	}

	/**
	 * 请求接口
	 * @param unknown $module 模块名称
	 * @param unknown $method 方法
	 * @param unknown $ssid  企业ID
	 * @param unknown $uid 用户ID
	 * @param unknown $uname 用户姓名
	 * @param unknown $param 参数
	 * @param unknown $timeout 超时时间
	 * @return {status:0/1,data:'',err_code:0,err_msg:''}
	 */
	private function sendRest($module,$method,$param = array(),$timeout = 10){
		
		//得到接口地址
		$url = $this->rest_site . "/api/$module/$method.html";
		
		//得到必须参数
		$param['ssid'] = $this->ssid;
		$param['uid'] = $this->uid;
		$param['uname'] = $this->uname;
		$param['app_id'] = $this->app_id;
		$param['data_type'] = $this->data_type;
		$param['authen'] = $this->getAuthen();

		$data = "" ;
		foreach($param as $key=>$value)
		{
			$data .= ($data == ""?"":"&") .$key . "=" . $value ;
		}
		
		//CURL提交数据
		$ch = curl_init();
		curl_setopt ($ch, CURLOPT_URL, $url);
		curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
		curl_setopt ($ch, CURLOPT_POST, 1);//POST
		curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 2);//连接超时
		curl_setopt ($ch, CURLOPT_RETURNTRANSFER, 1); //不返回状态
		curl_setopt ($ch, CURLOPT_TIMEOUT, $timeout);//执行超时
		$res = curl_exec($ch);
		curl_close($ch);
		
		//将字符串转为对象
		$res = json_decode($res);
		
		return $res;
	}
	
 
	
	/**
	 * 得到认证码
	 * @param unknown $ssid
	 * @param unknown $uid
	 * @return string
	 */
	private function getAuthen(){
		return hash('sha256',$this->app_id . $this->app_secret . $this->ssid . $this->uid);
	}

} 
?>